package mole.entities.particles 
{
	import net.flashpunk.Entity;
	import net.flashpunk.FP;
	import mole.Main;
	import net.flashpunk.graphics.Image
	
	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CParticle extends Entity
	{
		/**
		 * 
		 * @param	_fLife
		 * @param	_fDirX
		 * @param	_fDirY
		 * @param	_nVelocity
		 * @param	_nType
		 */
		public function CParticle(_fLife:Number, _fDirX:Number, _fDirY:Number, _nVelocity:int, _nType:int, _nScale:int)
		{
			m_fStartLife = m_fLife = _fLife;
			m_fDirX = _fDirX;
			m_fDirY = _fDirY;
			m_nVelocity = _nVelocity;
			
			graphic = m_Image = new Image(CParticleAssets.s_Sprites[_nType]);
			m_Image.scale = _nScale;
		}
		
		/**
		 * Callback de mise à jours.
		 */
		override public function update():void
		{
			m_fLife -= FP.elapsed;
			
			if (m_fLife <= 0)
			{
				Main.World.remove(this);
				return;
			}					
			
			// application de l'alpha.
			var fAlpha:Number = m_fLife / m_fStartLife;
			if(fAlpha <= 0.25)
				m_Image.alpha = fAlpha / 0.25;
			
			x += (m_fDirX * m_nVelocity) * FP.elapsed;
			y += (m_fDirY * m_nVelocity * FP.elapsed);// + ( Main.World.gravity * FP.elapsed);
		}
		
		private var m_fStartLife:Number;
		private var m_fLife:Number; ///< Durée de vie de la particule.
		private var m_fDirX:Number;	///< Direction sur l'axe X
		private var m_fDirY:Number;	///< Direction sur l'axe Y
		private var m_nVelocity:int;	///< Vitesse
		private var m_Image:Image;
	}
	
}